#include <iostream>
#include <vector>
#include <set>
#include <algorithm>
using namespace std;
void dfs(int node, int target, const vector<vector<int>>& graph, vector<bool>& visited, vector<int>& path, set<int>& all_nodes) {
    visited[node] = true;
    path.push_back(node);
    if (node != target) {
        for (int item : graph[node]) {
            if (!visited[item]) {
                dfs(item, target, graph, visited, path, all_nodes);
            }
        }
    } else {
        for (int item : path) {
            all_nodes.insert(item);
        }
    }
    path.pop_back();
    visited[node] = false;
}
int main() {
    int N, M, Q, P, ANS = 0;
    cin >> N >> M >> Q >> P;
    vector<int> A(N);
    vector<vector<int>> graph(N + 1);
    vector<pair<int, int>> queries(Q);
    vector<pair<int, int>> edges(M);
    vector<int> answers;
    for (int i = 0; i < N; ++i) {
        cin >> A[i];
    }
    for (int i = 0; i < M; ++i) {
        cin >> edges[i].first >> edges[i].second;
    }
    for (int i = 0; i < Q; ++i) {
        cin >> queries[i].first >> queries[i].second;
    }
    for (const pair<int, int> &edge : edges) {
        graph[edge.first].push_back(edge.second);
        graph[edge.second].push_back(edge.first);
    }
    for (int i = 0; i < Q; ++i) {
        set<int> all_nodes;
        vector<bool> visited(N + 1, false);
        vector<int> paths;
        vector<int> path;
        int A1 = queries[i].first;
        int B1 = queries[i].second;
        int nodeA = (A1 + ANS * P - 1) % N + 1;
        int targetB = (B1 + ANS * P - 1) % N + 1;
        dfs(nodeA, targetB, graph, visited, path, all_nodes);
        for (int node : all_nodes) {
            paths.push_back(A[node - 1]);
        }
        sort(paths.begin(), paths.end());
        int MEDIAN = paths[(paths.size() - 1) / 2];
        answers.push_back(MEDIAN);
        ANS = MEDIAN;
    }
    for (int answer : answers) {
        cout << answer << '\n';
    }
    return 0;
}